/* Copyright (c) 2005, 2012, Oracle and/or its affiliates. 
All rights reserved. */

/*
   DESCRIPTION
    This defines all the Install Constants 

   MODIFIED    (MM/DD/YY)
    pvallam     10/31/12 - adding exclamation and period in list of bad
                           chars
    xiaofwan    06/19/12 - Add FREE_SPACE_BUFFER_MULTIPLIER &
                           FREE_SPACE_BUFFER_MULTIPLIER_AIX
    pkuruvad    05/25/12 - Allow '!' for passwords
    jaikrish    03/19/12 - adding asmadmin and asmdba group for windows.
    pkuruvad    03/06/12 - making the namespaceURI variable to be version specific
    pvallam     02/28/12 - sizes with cdb
    jaikrish    01/29/12 - adding cman changes
    jaikrish    11/30/11 - add ntoramts entry
    wyou        11/28/11 - add TG_IVW_DLG_RB and TG_IVW_ERR_RB
    wyou        11/14/11 - add badchar list
    wyou        06/14/11 - add GSM_IVW_DLG_RB
    wyou        05/23/11 - add SoD related privilege
    rmallego    05/20/11 - adding NODE_LIVELINESS_CHECK_TIMEOUT constant
    pvallam     04/26/11 - XbranchMerge pvallam_bug-11770204_11203 from
                           st_install_11.2.0
    scravind    03/22/11 - XbranchMerge scravind_bug-11731701 from main
    scravind    03/13/11 - Fixing the bug 11731701
    pvallam     03/04/11 - adding flag fot MTS port
    rmallego    06/16/10 - adding CHECKSTORAGEFILESYSTEMTYPE_CONTROL_PROPERTY
                           constant
    rmallego    05/31/10 - removing '~' char from the bad character list
    svaggu      04/15/10 - Adding the "suppressRootMessage" string constant.
    dschrein    02/16/10 - windows port range constants from client to install
    svaggu      12/13/09 - Bad characters consolidation
    poosrini    09/27/09 - Project 31055: Config Wizard for GI
    rmallego    09/17/09 - adding VERSION_11_2 variable
    scravind    09/17/09 - Adding the constant for selecting all languages
    dchriste    01/26/09 - Add ASM OS group defaults for validation
    poosrini    03/24/08 - 
    dschrein    03/03/08 - add demos
    wyou        02/18/08 - add string[] supported language,
    dschrein    02/14/08 - more client things
    dschrein    02/04/08 - add client
    msubbann    01/22/08 - default names for Sys OS groups
    poosrini    01/17/08 - HA option transition to CRS shiphome
    ssampath    11/26/07 - XbranchMerge ssampath_dummy_tb_txn from
                           st_install_tb
    msubbann    10/17/07 - Add product version variable
    vtapadia    09/13/07 - Added Default Inventory Location directory
    aqazi       12/12/06 - 
    bktripat    10/11/06 - Creation
 */
package oracle.install.library.util;

import java.io.File;
import oracle.install.commons.util.Version;


public interface InstallConstants 
{
	
	public static final String CRS_IVW_ERR_RB = "oracle.install.ivw.crs.resource.CRSErrorResID";
    public static final String CRS_IVW_DLG_RB = "oracle.install.ivw.crs.resource.CRSDialogLabelResID";
    public static final String DB_IVW_ERR_RB = "oracle.install.ivw.db.resource.DBErrorResID";
    public static final String DB_IVW_DLG_RB = "oracle.install.ivw.db.resource.DBDialogLabelResID";
    public static final String CLIENT_IVW_ERR_RB = "oracle.install.ivw.client.resource.ClientErrorResID";
    public static final String CLIENT_IVW_DLG_RB = "oracle.install.ivw.client.resource.ClientDialogLabelResID";
    public static final String GSM_IVW_ERR_RB = "oracle.install.ivw.gsm.resource.GSMErrorResID";
    public static final String GSM_IVW_DLG_RB = "oracle.install.ivw.gsm.resource.GSMDialogLabelResID";
    public static final String COMMON_IVW_ERR_RB = "oracle.install.ivw.common.resource.CommonErrorResID";
    public static final String COMMON_IVW_DLG_RB = "oracle.install.ivw.common.resource.CommonDialogLabelResID";
    public static final String DEMOS_IVW_ERR_RB = "oracle.install.ivw.demos.resource.DemosErrorResID";
    public static final String DEMOS_IVW_DLG_RB = "oracle.install.ivw.demos.resource.DemosDialogLabelResID";
    public static final String TG_IVW_ERR_RB = "oracle.install.ivw.tg.resource.TGErrorResID";
    public static final String TG_IVW_DLG_RB = "oracle.install.ivw.tg.resource.TGDialogLabelResID";
    
    public static final String COMMON_UTIL_ERR_RB = "oracle.install.library.resource.CommonErrorResID";
    public static final String OUI_LIBRARY_LOC  = "oracle.installer.library_loc";
    public static final String INVPTR_LOC     = "oracle.installer.invPtrLoc";
    public static final String SOURCE_LOC  = "oracle.installer.sourceLoc";
    public static final String SCRATCH_PATH  = "oracle.installer.scratchPath";
    /*public static final int MIN_FREE_DISK_SPACE_SWONLY = 2600;
    public static final int MIN_FREE_DISK_SPACE_CRS_SWONLY = 2200;
    public static final int MIN_FREE_DISK_SPACE_CLIENT = 1024;
    public static final int MIN_FREE_DISK_SPACE_DEMOS = 1024;*/
    public static final long ORADATA_DISK_SPACE_REQUIRED = 1800;
    public static final long ORADATA_WITH_CDB_DISK_SPACE_REQUIRED = 3800;
    
    public static final int MAX_ORACLE_HOME_NAME_LENGTH = 128;
    
    public static final String INVENTORY_LOCATION= "oraInventory";
    
    public static final Version VERSION = Version.parseVersion("@<DB_VERSION>@");

    public static final String SYSDBA_DEFAULT_NAME = "dba";
    public static final String SYSOPER_DEFAULT_NAME = "oper";
    public static final String SYSBACKUP_DEFAULT_NAME = "backupdba";
    public static final String SYSDG_DEFAULT_NAME = "dgdba";
    public static final String SYSKM_DEFAULT_NAME = "kmdba";
    public static final String SYSASM_DEFAULT_NAME = "asmadmin";
    public static final String ASM_SYSDBA_DEFAULT_NAME = "asmdba";
    public static final String ASM_SYSOPER_DEFAULT_NAME = "asmoper";
    public static final String WIN_ASM_SYSDBA_DEFAULT_NAME = "ORA_ASMDBA";
    public static final String WIN_SYSASM_DEFAULT_NAME = "ORA_ASMADMIN";
    public static final String [] OUI_SUPPORTED_LANGUAGES = {"en","fr","ar","bn","pt_BR","bg","fr_CA","ca","hr","cs","da","nl","ar_EG","en_GB","et","fi","de","el","iw","hu","is","in","it","ja","ko","es","lv","lt","ms","es_MX","no","pl","pt","ro","ru","zh_CN","sk","sl","es_ES","sv","th","zh_TW","tr","uk","vi"};
    public static final int PORT_NUMBER_LENGTH_CONSTANT=5;    
    public static final String  DEFAULT_LANGUAGE = "en";
    public static final String  CVUQDISK_RPM_NAME="cvuqdisk";
    public static final String  CVUQDISK_RPM_MIN_VERSION="0";
    public static final String GETSHAREDPARTITIONLISTCVU_CONTROL_PROPERTY="oracle.install.cvu.getSharedPartitionList";
    public static final String CHECKSTORAGEFILESYSTEMTYPE_CONTROL_PROPERTY="oracle.install.cvu.checkSharedStorageFileSystemType";
    public static final String SELECT_ALL_LANGUAGES="all_langs";	
    public static final Version VERSION_11_2=Version.parseVersion("11.2.0.0.0");
    public static final Version VERSION_12_1=Version.parseVersion("12.1.0.0.0");

	//system property to identify config wizard execution - passed from config.pl
	public static final String CONFIGWIZARD_PROPERTY = "oracle.installer.configWizard";	
	
	//Bad characters
	public static final String INSTALL_COMMON_BADCHARS="!.@%^&*()+=\\|`~[{]};:'\",<>/?";
	public static final String INSTALL_BADCHARS_INSTALL_LOCATION_WIN="!@%^&*()+=|/`[{]};'\",<>?";
	public static final String INSTALL_BADCHARS_INSTALL_LOCATION_UNIX="!@%^&*()+=|`~[{]};:'\",<>?\\";
	public static final String INSTALL_BADCHARS_OSGROUP="!@%^&*()-+=\\|`~[{]};:'\",<>/?.#$ ";

    // Constants used for determining the default OraMTS Port Number
    // These represent the user-available range of ports on Windows
    public static final Integer WIN_PORT_NUMBER_RANGE_MIN=new Integer(49152);
    public static final Integer WIN_PORT_NUMBER_RANGE_MAX=new Integer(65535);
    
    // Flag for supressing the root script(s) message window
    public static final String SUPRESS_ROOT_MESSAGE_FLAG = "-suppressRootMessage";
    //Property for CRSIntegrity check. This property can be used to disable/enable the check accordingly.
    public static final String CHECK_CRS_INTEGRITY_PROPERTY="oracle.install.cvu.checkCRSIntegrity";

    // MTS Port flag
    public static final String MTS_PORT_NUMBER_FLAG="MTS_PORT";
    public static final int NODE_LIVELINESS_CHECK_TIMEOUT = 10;
    public static final String COMPONENT_ASSISTANTS_NETCA_CLIENT = "oracle.assistants.netca.client";
    public static final String COMPONENT_CRS = "oracle.crs";

    public static final String HOME_ORATAB_LOC="install"+File.separator+"oratab";
    public static final String COMPONENT_NTORAMTS = "oracle.ntoramts";

    public static final String COMPONENT_NETWORK_CMAN = "oracle.network.cman";
    public static final String COMPONENT_RDBMS_SCHEDULERAGENT = "oracle.rdbms.scheduler";
    
    public static final String DB_NAMESPACE_URI = "/oracle/install/rspfmt_dbinstall_response_schema_v" + "@<DB_VERSION_THREE_DIGITS>@";
    public static final String CRS_NAMESPACE_URI = "/oracle/install/rspfmt_crsinstall_response_schema_v" + "@<DB_VERSION_THREE_DIGITS>@";
    public static final String DEMOS_NAMESPACE_URI = "/oracle/install/rspfmt_demosinstall_response_schema_v" + "@<DB_VERSION_THREE_DIGITS>@";
    public static final String CLIENT_NAMESPACE_URI = "/oracle/install/rspfmt_clientinstall_response_schema_v" + "@<DB_VERSION_THREE_DIGITS>@";
    public static final String GSM_NAMESPACE_URI = "/oracle/install/rspfmt_gsminstall_response_schema_v" + "@<DB_VERSION_THREE_DIGITS>@";
    public static final String TG_NAMESPACE_URI = "/oracle/install/rspfmt_tginstall_response_schema_v" + "@<DB_VERSION_THREE_DIGITS>@";
    public static final String ROOT_MACROS_LOCATION = "install"+File.separator+"utl"+File.separator+"rootmacro.sh";    
    public static final String INSTALL_BADCHARS_HOSTNAME=" !@%^&*()+=\\|`~[{]};'\",<>/?#$:";
    public static final int FREE_SPACE_BUFFER_MULTIPLIER = 1;
    public static final int FREE_SPACE_BUFFER_MULTIPLIER_AIX = 5;
}
